<?php
/**
 * @file
 * User page callbacks for the socialloginandsocialshare module.
 */
/**
 * Submit socialloginandsocialshare identities for the specified user.
 */
function socialloginandsocialshare_user_identities_submit($account, $token = '') {
  unset($_SESSION['lr_token']);
  $output = '';
  if (!class_exists(LoginRadius)) {
    include 'socialloginandsocialshare.loginradius.inc';
  }
  $obj = new LoginRadius();
  drupal_set_title(check_plain($account->name));
  if (user_is_logged_in() && $obj->loginradius_is_valid_guid($token)) {
    if (!class_exists(LoginRadius)) {
      include 'socialloginandsocialshare.loginradius.inc';
    }
    $secret = trim(variable_get('socialloginandsocialshare_apisecret', ''));
    $userprofile = $obj->loginradius_get_user_profiledata($token);
    if (isset($userprofile->ID) && $userprofile->ID != '' && user_is_logged_in()) {
      $lrdata = socialloginandsocialshare_getuser_data($userprofile);
      // $authname_exist =   db_query("SELECT authname FROM {authmap} WHERE authname = '%s'", $lrdata['id']);
      $result = db_query("SELECT provider FROM {authmap} am INNER JOIN {socialloginandsocialshare_mapusers} sm ON am.aid = sm.aid WHERE module = 'socialloginandsocialshare'  AND uid = %d", $account->uid);
      $mapped = '';
      while ($identity = db_fetch_object($result)) {
        if ($identity->provider == $lrdata['provider']) {
          $mapped = 'yes';
        }
      }
      $authname_exist = db_query("SELECT authname FROM {authmap} am INNER JOIN {socialloginandsocialshare_mapusers} sm ON am.aid = sm.aid WHERE am.authname = '%s'",
        check_plain($lrdata['id']));
      $authname_exist = db_fetch_array($authname_exist);

      if ($mapped != 'yes') {
        if (empty($authname_exist) && !$authname_exist) {

          db_query("DELETE FROM {authmap} WHERE authname=%s", check_plain($lrdata['id']));
          db_query("INSERT INTO {authmap} (uid, authname, module) VALUES ('%d' ,'%s' ,'%s')", $account->uid, check_plain($lrdata['id']), 'socialloginandsocialshare');
          if (variable_get('socialloginandsocialshare_update_profile', '') == 1) {
            if (variable_get('user_pictures', 1) && !empty($lrdata['thumbnail'])) {
              socialloginandsocialshare_insert_picture($lrdata, $account);
            }
          }
          $aid = db_query("SELECT aid FROM {authmap} WHERE authname = '%s'", $lrdata['id']);
          $aid = db_fetch_object($aid);
          $check_aids = db_query("SELECT aid FROM {socialloginandsocialshare_mapusers} WHERE aid = '%s'", $aid->aid);
          $check_aid = db_fetch_object($check_aids);
          if (!empty($check_aid->aid)) {
            db_query("DELETE FROM {socialloginandsocialshare_mapusers} WHERE  aid='%d'", $check_aid->aid);
          }
          db_query("INSERT INTO {socialloginandsocialshare_mapusers} VALUES ('%d' ,'%s' ,'%s')", $aid->aid, $lrdata['provider'], check_plain($lrdata['id']));
          drupal_set_message(t("Your account sucessfully mapped with this account."));
        }
        else {
          drupal_set_message(t("This social ID is already linked with an account. Kindly unmap the current ID before linking new Social ID."), 'error');
        }
      }
      else {
        drupal_set_message(t("This account is already linked with an account. try to choose another account."), 'error');
      }
      $dest = urldecode(substr(drupal_get_destination(), 12));
      drupal_goto($dest);

    }
  }
}

/**
 * Menu callback Delete the specified socialloginandsocialshare identity from the system.
 */
function socialloginandsocialshare_user_delete($account, $providerid = 0) {
  db_query("DELETE FROM {authmap} WHERE uid=%d AND authname=%d AND module='socialloginandsocialshare'", $account->uid, $providerid);
  db_query("DELETE FROM {socialloginandsocialshare_mapusers} WHERE  provider_id='%d'", $providerid);
  if (db_affected_rows()) {
    drupal_set_message(t('Social Login ID deleted.'));
  }
  drupal_goto('user/' . $account->uid . '/edit');
}

function socialloginandsocialshare_check_jsexist($val) {
  $current_js = drupal_add_js(NULL, NULL, 'header');
  $current_js_settings = $current_js['setting'];
  $mysetting_isset = FALSE;
  if (is_array($current_js_settings)) {
    foreach ($current_js_settings as $current_js_setting) {
      if (array_key_exists($val, $current_js_setting)) {
        // We found it so set the flag to true.
        $mysetting_isset = TRUE;
      }
    }
  }
  return $mysetting_isset;
}