<?php

/**
 * @file
 * socialloginandsocialshare Field mapping.
 */


/**
 * Function that adding field data.
 */
function socialloginandsocialshare_field_create_user(&$form_state, $lrdata) {
  $field_map = variable_get('socialloginandsocialshare_user_fields', array());
  $field_convert_info = socialloginandsocialshare_field_convert_info();
  $instances = field_info_instances('user', 'user');
  foreach ($instances as $field_name => $instance) {
    $field = field_info_field($instance['field_name']);
    if (isset($field_map[$field_name]) && isset($field_convert_info[$field['type']]['callback'])) {
      $callback = $field_convert_info[$field['type']]['callback'];
     $socialloginandsocialshare_property_name = $field_map[$field_name];
      if ($value = $callback($socialloginandsocialshare_property_name, $lrdata, $field, $instance)) {
       $form_state[$field_name][LANGUAGE_NONE][0] = $value;
      }
    }
  }
}

/**
 * Function that provide a callback for data map.
 */
function socialloginandsocialshare_field_convert_info() {
  $convert_info = array(
    'text' => array(
      'label' => t('Text'),
      'callback' => 'socialloginandsocialshare_field_convert_text',
    ),
    'text_long' => array(
      'label' => t('Long text'),
      'callback' => 'socialloginandsocialshare_field_convert_text',
    ),
    'list_text' => array(
      'label' => t('List (\'text\')'),
      'callback' => 'socialloginandsocialshare_field_convert_list',
    ),
    'datetime' => array(
      'label' => t('Date'),
      'callback' => 'socialloginandsocialshare_field_convert_date',
    ),
    'date' => array(
      'label' => t('Date'),
      'callback' => 'socialloginandsocialshare_field_convert_date',
    ),
    'datestamp' => array(
      'label' => t('Date'),
      'callback' => 'socialloginandsocialshare_field_convert_date',
    ),
  );
  drupal_alter('socialloginandsocialshare_field_convert_info', $convert_info);
  return $convert_info;
}

/**
 * Convert text and text_long data.
 */
function socialloginandsocialshare_field_convert_text($socialloginandsocialshare_property_name, $lrdata, $field, $instance) {
  $value = NULL;
  if (isset($lrdata[$socialloginandsocialshare_property_name])) {
    if (is_string($lrdata[$socialloginandsocialshare_property_name])) {
      $value = $lrdata[$socialloginandsocialshare_property_name];
    }
    elseif (is_object($lrdata[$socialloginandsocialshare_property_name])) {
      $object = $lrdata[$socialloginandsocialshare_property_name];
      if (isset($object->name)) {
        $value = $object->name;
      }
    }
  }
  return $value ? array('value' => $value) : NULL;
}

/**
 * Convert list data.
 */
function socialloginandsocialshare_field_convert_list($socialloginandsocialshare_property_name, $lrdata, $field, $instance) {
  if (!is_string($lrdata[$socialloginandsocialshare_property_name])) {
    return;
  }
  $options = list_allowed_values($field);
  $best_match = 0.0;
  $best_option = NULL;
  $sl_option = is_string($lrdata[$socialloginandsocialshare_property_name]) ? $lrdata[$socialloginandsocialshare_property_name] : '';
  $match_sl = strtolower($lrdata[$socialloginandsocialshare_property_name]);
  foreach ($options as $key => $option) {
    $option = trim($option);
    $match_option = strtolower($option);
    $this_match = 0;
    similar_text($match_option, $match_sl, $this_match);
    if ($this_match > $best_match) {
      $best_match = $this_match;
      $best_option = $option;
      $best_key = $key;
    }
  }
  return isset($best_key) ? array('value' => $best_key) : NULL;
}

/**
 * Convert date data.
 */
function socialloginandsocialshare_field_convert_date($socialloginandsocialshare_property_name, $lrdata, $field, $instance) {
  $value = NULL;
  $sldate = explode('/', $lrdata[$socialloginandsocialshare_property_name]);
  if (count($sldate) == 3) {
    $date = new DateObject($lrdata[$socialloginandsocialshare_property_name]);
    if (date_is_date($date)) {
      $format = $field['type'] == 'datestamp' ? DATE_FORMAT_UNIX : DATE_FORMAT_ISO;
      $value = array(
        'value' => $date->format($format, TRUE),
        'date_type' => $field['type'],
      );
    }
  }
  return $value;
}
/**
 * Return a all list of social user properties.
 */
function socialloginandsocialshare_user_properties($include_common = FALSE) {
  $common = array(
    'id' => array(
      'label' => t('Provider ID'),
    ),
    'provider' => array(
      'label' => t('Social Provider'),
      'field_types' => array('text'),
    ),
    'fullname' => array(
      'label' => t('Full name'),
      'field_types' => array('text'),
    ),
    'fname' => array(
      'label' => t('First name'),
      'field_types' => array('text'),
    ),
    'lname' => array(
      'label' => t('Last name'),
      'field_types' => array('text'),
    ),
    'email' => array(
      'label' => t('E-mail'),
      'field_types' => array('text'),
    ),
    'gender' => array(
      'label' => t('Gender'),
      'field_types' => array('text', 'list_text'),
    ),
    'dob' => array(
      'label' => t('Birthday'),
      'field_types' => array('text', 'date', 'datetime', 'datestamp'),
    ),
    'aboutme' => array(
      'label' => t('About me (a short bio)'),
      'field_types' => array('text', 'text_long'),
    ),
    'address' => array(
      'label' => t('Location'),
      'field_types' => array('text'),
    ),
    'company' => array(
      'label' => t('Work history'),
      'field_types' => array('text'),
    ),
    'website' => array(
      'label' => t('Profile url'),
      'field_types' => array('text'),
    ),
  );
  drupal_alter('socialloginandsocialshare_user_properties', $common);
  ksort($common);
  if (!$include_common) {
    $common = array_diff_key($common);
  }
  return $common;
}