# Solo Utilities

Solo Utilities is a module designed to enhance the Solo theme with additional
features and customization options. The initial release of Solo Utilities
introduces the ability to set custom widths for individual nodes, giving site
builders and content creators more control over the presentation of their
content. Future updates will include new features to further enhance the Solo
theme.

## Table of Contents

1. [Features](#features)
2. [Requirements](#requirements)
3. [Installation](#installation)
4. [Configuration](#configuration)
5. [Usage](#usage)
6. [Future Plans](#future-plans)
7. [Maintainers](#maintainers)
8. [License](#license)

## Features

- **Custom Node Widths**: Set custom widths for individual nodes to tailor the
  display of your content.
- **Future Enhancements**: Solo Utilities will be updated with new features
  that enhance the Solo theme.

## Requirements

- **Solo theme**: Ensure the Solo theme is installed and active.
- **Node module**: Core Drupal module that must be enabled.

## Installation

1. **Download the module**: Place the Solo Utilities module in the
   `modules/custom` directory of your Drupal installation.
2. **Enable the module**:
   - **Using Drush**: Run `drush en solo_utilities -y` in the command line.
   - **Using Drupal Admin Interface**: Navigate to **Extend**, find the **Solo
     Utilities** module, enable it, and save the configuration.

## Configuration

1. Ensure the Solo theme is active and configured correctly.
2. Navigate to the theme settings of the Solo theme.
3. If the Solo Utilities module is enabled, you will see an option to enable
   custom widths for individual nodes.
4. Configure the settings as needed.

## Usage

1. When creating or editing a node, you will see a dropdown to select a custom
   width for the node.
2. Choose the desired width or select **None** to use the default width.

## Future Plans

Solo Utilities is designed to be a foundational module for extending the Solo
theme. Future updates will include additional features and improvements to
further enhance the capabilities of the Solo theme.

## Maintainers

- **Alaa Haddad** - [Alaa Haddad](https://www.alaahaddad.com)

## License

This project is licensed under the [GPL-2.0-or-later](https://www.gnu.org/licenses/gpl-2.0.html).
