<?php

namespace Drupal\solr_search_synonym\Plugin\solr_search_synonym\export;

use Drupal\solr_search_synonym\Export\ExportPluginBase;
use Drupal\solr_search_synonym\Export\ExportPluginInterface;

/**
 * Provides a synonym export plugin for Apache Solr..
 *
 * @SearchSolrSynonymExport(
 *   id = "solr",
 *   label = @Translation("Solr"),
 *   description = @Translation("Synonym export plugin for Apache Solr")
 * )
 */
class Solr extends ExportPluginBase implements ExportPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function getFormattedSynonyms(array $synonyms) {
    $lines = [];

    $lines[] = "#";
    $lines[] = "# Synonyms file for Apache Solr generated by Solr Search Synonym.";
    $lines[] = "# See file https://www.drupal.org/project/solr_search_synonym.";
    $lines[] = "#";
    $lines[] = "";

    // Generate a line for each synonym.
    foreach ($synonyms as $synonym) {
      $lines[] = $this->generateLine($synonym->word, $synonym->synonyms, $synonym->type);
    }

    return implode("\n", $lines);
  }

  /**
   * Generate a single synonyms line for the export file.
   *
   * @param string $word
   *   The main word.
   * @param string $synonyms
   *   The comma separated string with synonyms.
   * @param string $type
   *   Synonym (synonym) og Spelling error (spelling_error).
   *
   * @return string
   *   Return the single line with synonyms and the corresponding word.
   */
  private function generateLine($word, $synonyms, $type) {
    $line = '';

    switch ($type) {
      case 'synonym':
        // We force using of equivalent mappings for type = synonym.
        $line = "{$word}, {$synonyms}";
        break;

      case 'spelling_error':
        $line = "{$word} => {$synonyms}";
        break;
    }
    return $line;
  }

}
