# Soundcite

Embed [SoundCite JS](https://soundcite.knightlab.com/) inline audio clips in your Drupal content.
SoundCite allows you to add audio that plays seamlessly within your text content.

## Features

- **CKEditor 5 integration** - Add inline audio clips directly in your text editor
- **Field formatter** - Display audio file fields as interactive SoundCite clips
- **Flexible audio timing** - Configure start/end times and number of plays
- **Multiple audio formats** - Support for mp3, wav, ogg, m4a, aac, flac
- **Link text options** - Use custom text, file descriptions, or filenames as clickable links
- **Easy configuration** - Simple settings form for SoundCloud integration and styling

## Installation

Install via Composer:
```bash
composer require drupal/soundcite
```

Or download and place in your `modules/contrib` directory.

## Usage

### CKEditor 5 Integration
1. Enable the module
2. Add the SoundCite button to your text format toolbar
3. Insert audio clips directly in your content

### Field Formatter
1. Create or edit a file field that accepts audio files
2. In the field's display settings, select "Soundcite Audio Player" formatter
3. Configure start/end times, play count, and link text options

## Configuration

Visit `/admin/config/content/soundcite` to configure:
- SoundCloud Client ID (for SoundCloud URLs)
- Background color for audio player

## Requirements

- Drupal >=10.5 or 11
- File module (required)
- CKEditor 5 (optional, for editor integration)

