# Setup Drupal CMS

## Install DDEV
The following instructions to setup DDEV for working with Drupal links to the DDEV documentation.

1. **Check requirements**
Confirm that your system meets the requirements listed in the [DDEV system requirements](https://ddev.readthedocs.io/en/stable/).

2. **Install Docker**
Go to [Docker installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/), select your environment and follow the instructions. If [installing DDEV on Docker Engine on WSL2 on Windows](https://ddev.readthedocs.io/en/stable/), the DDEV installation script will handle Docker installation.

3. **Install DDEV**
Go to [Docker installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/), select your environment and follow the instructions.

## Install Drupal

```bash
mkdir my-drupal-site && cd my-drupal-site
ddev config --project-type=drupal --docroot=web
ddev start
ddev composer create drupal/recommended-project
ddev composer require drush/drush
ddev drush site:install --account-name=admin --account-pass=admin -y
ddev launch
```

This should open a fully installed and working Drupal(official recommended) in your browser using DDEV. This setup provides a consistent, Docker-based environment that’s perfect for Drupal development.

# Setup Experience Builder

## Install module

We need to add a repository because the experience_builder project does not have a dev release yet.

> **_NOTE:_**
> You may see a number of warnings when running `ddev npm install` and `ddev npm run build`.
> It is recommended to use nvm to manage node version. Refer https://github.com/nvm-sh/nvm/blob/master/README.md

```bash
ddev composer require 'drupal/canvas:1.x-dev@dev'
```

Add _$settings['extension_discovery_scan_tests'] = TRUE;_ to the end of the _web/sites/default/settings.php_ file.

```bash
ddev drush pm:install canvas canvas_dev_standard
cd web/modules/contrib/canvas/ui
ddev npm install
ddev npm run build
cd -
ddev drush cr
```

## Check in Drupal UI

1. Go to _site_domain/node/add/article_ (note that XB **only** works with articles right now,  If you do not have an article content type, please create one.)
2. Add a dummy title and click the **"Save"** button, This will create a node with an empty canvas for the field field_xb_demo.
3. In the toolbar, click **"Experience Builder"** to see XB
4. See components that are available at _site_domain/admin/structure/component_
5. If it shows up without problems, then all good for now.

# Setup theme
* From terminal navigate to `cd web/themes/` and create custom directory `mkdir contrib`
* Now clone repository inside `contrib` directory
  * `cd contrib` then run `git clone git@git.drupal.org:project/space_ds.git`
* Enable the theme `ddev drush theme:enable space_ds`
* Set the theme as default `ddev drush config:set system.theme default space_ds -y`
* Navigate to `web/themes/contrib/space_ds` theme directory and run below command:
  * `npm install` (Node version should be: v20.11.0 or > v20.11.0)
  * `npm run build` which will generate CSS files inside each components directory from `.pcss` file if exists.
  * `npm run watch` continues watch of `.pcss` file and compile into `.css` file. (Mostly required at the time of development)
  * `npm run dev:storybook` start storybook. (Mostly required at the time of development) 
  Note - Right now storybook is WIP(work in progress) state so you might face some issues.
* Clear cache once `ddev drush cr`
* Use `ddev launch` to check the site OR use `ddev drush uli` to login into Drupal dashboard.
* On XB, components that begin with the name **"Space"** are part of the space design system. For instance, the _Space Image Card_ is ready for use! 🥳
