/**
 * Accordion with Image
 */

(function accordionWithImageComp() {
  document.addEventListener("DOMContentLoaded", function () {
    // Initialize accordion items
    document.querySelectorAll('.accordion-with-image').forEach((accordion) => {
      const firstItem = accordion.querySelector('.accordion-item:first-child .accordion-item-inner');
      if (firstItem) {
        firstItem.classList.add('opened');
      }
    });

    // Handle accordion item clicks (excluding variation-4)
    document
      .querySelectorAll(".accordion-with-image:not(.variation-4) .accordion-item-inner .ac-title")
      .forEach((title) => {
        title.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();

          const itemInner = this.closest('.accordion-item-inner');
          itemInner.classList.add('opened');
          itemInner.classList.remove('closed');

          const siblings = Array.from(itemInner.closest('.accordion-item').parentElement.children);
          siblings.forEach((sibling) => {
            if (sibling !== itemInner.closest('.accordion-item')) {
              sibling.querySelector('.accordion-item-inner').classList.remove('opened');
              sibling.querySelector('.accordion-item-inner').classList.add('closed');
            }
          });

          const accessibilityTxt = this.querySelector('.ac-accessibilty-txt');
          if (itemInner.classList.contains('opened')) {
            accessibilityTxt.textContent = 'click to close accordion';
          } else {
            accessibilityTxt.textContent = 'click to open accordion';
          }
        });
      });

    // Handle variation-1-2 accordion clicks
    document
      .querySelectorAll('.accordion-with-image.variation-1-2 .accordion-item-inner')
      .forEach((itemInner) => {
        itemInner.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();

          this.classList.add('opened');
          this.classList.remove('closed');

          const siblings = Array.from(this.closest('.accordion-item').parentElement.children);
          siblings.forEach((sibling) => {
            if (sibling !== this.closest('.accordion-item')) {
              sibling.querySelector('.accordion-item-inner').classList.remove('opened');
              sibling.querySelector('.accordion-item-inner').classList.add('closed');
            }
          });

          const accessibilityTxt = this.querySelector('.ac-accessibilty-txt');
          if (this.classList.contains('opened')) {
            accessibilityTxt.textContent = 'click to close accordion';
          } else {
            accessibilityTxt.textContent = 'click to open accordion';
          }
        });
      });

    window.addEventListener('resize', handleResize);
    handleResize();
  });
})();
