document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.splide').forEach(function (sliderElement) {
    // Default values
    const slidesPerView = parseInt(sliderElement.dataset.slidesPerView) || 1; // Default slides for desktop
    const slidesOnTablet = parseInt(sliderElement.dataset.slidesOnTablet) || 1; // Tablet-specific slides
    const slidesOnMobile = parseInt(sliderElement.dataset.slidesOnMobile) || 1; // Mobile-specific slides
    const slideType = sliderElement.dataset.slideType || 'slide'; // Slider type
    const autoplay = sliderElement.dataset.autoplay === 'true'; // Autoplay toggle
    const arrows = sliderElement.dataset.arrows === 'true'; // Arrows toggle
    const slideFocus = sliderElement.dataset.slideFocus || 'none'; // Slide focus setting
    const counter = sliderElement.classList.contains('number-fraction-pagination'); // Fraction pagination check

    // Fetch padding values dynamically and ensure they have 'px'
    const slidePaddingLeft = sliderElement.dataset.slideSpaceLeft
      ? `${sliderElement.dataset.slideSpaceLeft}px`
      : '0px';
    const slidePaddingRight = sliderElement.dataset.slideSpaceRight
      ? `${sliderElement.dataset.slideSpaceRight}px`
      : '0px';

    // Determine pagination style based on classes
    let pagination = false;
    if (sliderElement.classList.contains('dot-pagination')) {
      pagination = 'dots';
    } else if (sliderElement.classList.contains('line-pagination')) {
      pagination = 'line';
    } else if (sliderElement.classList.contains('number-dash-pagination')) {
      pagination = 'number-dash';
    } else if (sliderElement.classList.contains('number-fraction-pagination')) {
      pagination = 'number-fraction';
    }

    // Apply specific settings for the thumbnail-slider
    if (sliderElement.classList.contains('thumbnail-slider')) {
      pagination = false; // Disable pagination
      arrows = false; // Disable arrows
    }

    const splide = new Splide(sliderElement, {
      type: slideType, // Default slide type
      perPage: slidesPerView, // Default slides for desktop
      autoplay: autoplay, // Autoplay based on dataset
      arrows: arrows, // Arrows toggle
      pagination: pagination, // Pagination toggle
      interval: 3000,
      rewind: false,
      gap: sliderElement.classList.contains('thumbnail-sync-slider') ? '0' : '1rem', // Set gap to 0 for thumbnail slider
      focus: slideFocus === 'center' ? 'center' : false, // Set focus dynamically
      padding: {
        left: slidePaddingLeft,
        right: sliderElement.classList.contains('thumbnail-sync-slider') ? '80px' : slidePaddingRight, // Apply the customized right padding
      },
      breakpoints: {
        768: { perPage: slidesOnMobile }, // Mobile configuration
      },
      classes: {
        pagination:
          pagination === 'dots'
            ? 'splide__pagination splide__pagination--dots'
            : pagination === 'line'
            ? 'splide__pagination splide__pagination--line'
            : pagination === 'number-dash'
            ? 'splide__pagination splide__pagination--number-dash'
            : pagination === 'number-fraction'
            ? 'splide__pagination splide__pagination--number-fraction'
            : '',
      },
    });

    splide.mount();

    // Add custom logic for number-fraction-pagination (if counter is enabled)
    if (counter) {
      const updateCounter = () => {
        const currentSlide = splide.index + 1; // Splide index starts at 0, so add 1
        const totalSlides = splide.length; // Total number of slides
        const counterElement = sliderElement.querySelector('.splide__counter');
        
        if (counterElement) {
          counterElement.innerHTML = `
            <span class="splide__slide-index">${String(currentSlide).padStart(2, '0')}</span>
            <span class="divider mx-1.5">/</span>
            <span class="splide__slide-total">${String(totalSlides).padStart(2, '0')}</span>`;
        }
      };
    
      // Initialize and update the counter on events
      splide.on('mounted move', updateCounter); // Update on mount and slide change
      updateCounter(); // Initial update
    }
  });
});
