const gulp = require('gulp');
const postcss = require('gulp-postcss');
const tailwindcss = require('tailwindcss');
const autoprefixer = require('autoprefixer');
const nested = require('postcss-nested');
const rename = require('gulp-rename');
const cleanCSS = require('gulp-clean-css');

// Task to compile and minify .pcss to .css with Tailwind and Twig support
gulp.task('compilePCSS', () => {
  return gulp
    .src('./**/*.pcss', { base: './' }) // Maintain directory structure
    .pipe(
      postcss([
        nested(), // Add support for nested CSS
        tailwindcss('./tailwind.config.js'), // Tailwind configuration file
        autoprefixer(),
      ])
    )
    .pipe(
      rename((filePath) => {
        filePath.extname = '.css'; // Change extension to .css
      })
    )
    .pipe(cleanCSS()) // Minify the CSS
    .pipe(gulp.dest('./')); // Output files in the same directory as their sources
});

// Watch task to monitor changes in .pcss and .twig files
gulp.task('watch', () => {
  gulp.watch(
    ['./**/*.pcss', './components/**/*.twig', './templates/**/*.html.twig'], // Watch .pcss and .twig files
    gulp.series('compilePCSS') // Recompile on changes
  );
});

// Default task (compiles and watches)
gulp.task('default', gulp.series('compilePCSS'));
