(function sidebarComp() {
  document.addEventListener("DOMContentLoaded", function () {
    // Sidebar Menu
    const menuItems = document.querySelectorAll('.sidebar__menu > li.navigation__item--has-children');
    menuItems.forEach(function (item) {
      item.addEventListener('click', function (e) {
        e.stopPropagation();
        
        // Toggle 'active' class and remove it from siblings
        this.classList.toggle('active');
        Array.from(this.parentElement.children).forEach(function (sibling) {
          if (sibling !== item) {
            sibling.classList.remove('active');
          }
        });

        // Remove 'active' class from sub-menu items
        const activeSubMenuItems = document.querySelectorAll('.sub-menu > li.navigation__item--has-children.active');
        activeSubMenuItems.forEach(function (subMenuItem) {
          subMenuItem.classList.remove('active');
        });
      });
    });

    // Sidebar Sub Menu
    const subMenuItems = document.querySelectorAll('.sub-menu > li.navigation__item--has-children');
    subMenuItems.forEach(function (item) {
      item.addEventListener('click', function (e) {
        e.stopPropagation();
        
        // Toggle 'active' class
        this.classList.toggle('active');
      });
    });
  });
})();
