(function stickyJumpLinkContentComp() {
  document.addEventListener("DOMContentLoaded", function () {
    // Sticky tag pills click event
    const stickyTagPills = document.querySelectorAll('.sticky-tag-pills');
    stickyTagPills.forEach(function (pill) {
      pill.addEventListener('click', function (event) {
        // Prevent default link behavior
        event.preventDefault();
        event.stopImmediatePropagation();

        // Get target section ID from the href attribute
        const target = document.querySelector(this.getAttribute('href'));
        const container = document.querySelector('.sticky-jump-link-row-inner');

        if (target && container) {
          // Scroll to target section within the container
          const scrollTop = target.getBoundingClientRect().top
            - container.getBoundingClientRect().top
            + container.scrollTop;

          container.scrollTo({
            top: scrollTop,
            behavior: 'smooth'
          });
        }
      });
    });

    // Scroll event on container
    const container = document.querySelector('.sticky-jump-link-row-inner');
    if (container) {
      container.addEventListener('scroll', function () {
        const stickyItems = document.querySelectorAll('.sticky-jump-link-item');
        stickyItems.forEach(function (item, index) {
          const itemIn = item.querySelector('.item-in');
          const containerRect = container.getBoundingClientRect();
          const sectionTop = itemIn.getBoundingClientRect().top - containerRect.top + container.scrollTop;
          const sectionBottom = sectionTop + itemIn.offsetHeight / 2;
          const containerScrollTop = container.scrollTop;
          const containerScrollBottom = containerScrollTop + container.offsetHeight / 2;

          if (sectionTop < containerScrollBottom && sectionBottom > containerScrollTop) {
            // Add 'active' class to the current section
            item.classList.add('active');
            item.parentElement.querySelectorAll('.sticky-jump-link-item').forEach(sibling => {
              if (sibling !== item) sibling.classList.remove('active');
            });

            // Fade in content for screens >= 1024px
            if (window.innerWidth >= 1024) {
              const contentInner = item.querySelector('.content-inner');
              if (contentInner) contentInner.style.opacity = 1;
            }

            // Match pills to active section
            stickyTagPills.forEach((pill, pillIndex) => {
              if (index === pillIndex) {
                pill.classList.add('active');
              } else {
                pill.classList.remove('active');
              }
            });
          } else {
            // Remove 'active' class if section is not in view
            item.classList.remove('active');

            if (window.innerWidth >= 1024) {
              const contentInner = item.querySelector('.content-inner');
              if (contentInner) contentInner.style.opacity = 0;
            }
          }
        });
      });
    }
  });
})();
