const gulp = require('gulp');
const postcss = require('gulp-postcss');
const tailwindcss = require('tailwindcss');
const autoprefixer = require('autoprefixer');
const nested = require('postcss-nested');
const rename = require('gulp-rename');
const cleanCSS = require('gulp-clean-css');
const del = require('del');

// Task to clean old CSS files before rebuilding
gulp.task('clean', async () => {
  console.log('🧹 Cleaning old CSS files...');
  const deletedPaths = await del([
    './components/**/*.css',
  ]);
  console.log(`✅ Deleted ${deletedPaths.length} CSS files`);
});

// Task to compile and minify .pcss to .css with Tailwind and Twig support
gulp.task('compilePCSS', () => {
  console.log('🔨 Compiling PCSS files to CSS...');
  return gulp
    .src('./components/**/*.pcss', { base: './' }) // Maintain directory structure
    .pipe(
      postcss([
        nested(), // Add support for nested CSS
        tailwindcss('./tailwind.config.js'), // Tailwind configuration file
        autoprefixer(),
      ])
    )
    .pipe(
      rename((filePath) => {
        filePath.extname = '.css'; // Change extension to .css
      })
    )
    .pipe(cleanCSS()) // Minify the CSS
    .pipe(gulp.dest('./')); // Output files in the same directory as their sources
});

// Watch task to monitor changes in .pcss and .twig files
gulp.task('watch', () => {
  gulp.watch(
    ['./components/**/*.pcss', './components/**/*.twig', './templates/**/*.html.twig'], // Watch .pcss and .twig files
    gulp.series('clean', 'compilePCSS') // Clean and recompile on changes
  );
});

// Default task (cleans old files and compiles)
gulp.task('default', gulp.series('clean', 'compilePCSS'));
