# Spacer Block

The Spacer Block module provides a flexible block 
that allows site administrators to add vertical spacing between content 
elements. It supports predefined sizes, custom sizes and fluid spacing 
using CSS clamp.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/spacer_block).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/spacer_block).

## Table of Contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Maintainers](#maintainers)

## Requirements

This module requires no modules outside of Drupal core. However, it is designed 
to work best with the **Layout Builder** module for layout building.

## Installation
Install as you would normally install a contributed Drupal module. For 
further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Enable the module at Administration > Extend.
1. Place the block "Spacer block" between two content element.

## Usage

Once installed, the block will be available in the Block Layout, Gutenberg 
editor or Edit layout:

1. **Standard Mode**: Select a predefined size (e.g., Medium 128) from the 
   dropdown.
1. **Custom Size**: Check "Use Spacer Custom Size" to apply a specific 
   height value. Note that these two custom options are mutually exclusive; 
   enabling one will disable the other.

## Maintainers

- Sanket Prajapati - [sanketprajapati](https://www.drupal.org/u/sanketprajapati)
