<?php

namespace Drupal\spammaster\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Class firewall controller.
 */
class SpamMasterFirewallController extends ControllerBase {

  /**
   * Symfony\Component\HttpFoundation\RequestStack definition.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * {@inheritdoc}
   */
  public function __construct(RequestStack $requestStack) {
    $this->requestStack = $requestStack;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('request_stack')
    );
  }

  /**
   * Firewall block page callback.
   */
  public function spamMasterFirewall(): array {
    $request = $this->requestStack->getCurrentRequest();
    $client_ip = $request->getClientIp();
    $user_agent = $request->headers->get('User-Agent');

    return [
      '#theme' => 'firewall',
      '#type' => 'page',
      '#attached' => [
        'library' => [
          'spammaster/spammaster-firewall',
        ],
      ],
      '#spam_master_firewall_ip' => $client_ip,
      '#spam_master_firewall_browser' => $user_agent,
    ];
  }

}
