<?php

namespace Drupal\spammaster;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Component\Serialization\Json;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\State\StateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

/**
 * Class service.
 */
class SpamMasterHoneypotService {

  /**
   * The database connection object.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $connection;

  /**
   * Symfony\Component\HttpFoundation\RequestStack definition.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * The Config Factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The state.
   *
   * @var \Drupal\Core\State\StateInterface
   */
  protected $state;

  /**
   * The Time Service.
   *
   * @var \Drupal\Component\Datetime\TimeInterface
   */
  protected $time;

  /**
   * The form class.
   *
   * @var \Drupal\Core\Form\FormInterface
   */
  protected $spamFormId;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasterip;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasteragent;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasterextrafield1;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasterextrafield2;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasterreferer;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasterurl;

  /**
   * The SpamMasterHoneypotService service.
   *
   * @var \Drupal\spammmaster\SpamMasterHoneypotService
   */
  protected $spammasteruserid;

  /**
   * The SpamMasterCollectService Service.
   *
   * @var \Drupal\spammaster\SpamMasterCollectService
   */
  protected $collectService;

  /**
   * The SpamMasterUserService Service.
   *
   * @var \Drupal\spammaster\SpamMasterUserService
   */
  protected $userService;

  /**
   * The SpamMasterApiService Service.
   *
   * @var \Drupal\spammaster\SpamMasterApiService
   */
  protected $apiService;

  /**
   * {@inheritdoc}
   */
  public function __construct(Connection $connection, RequestStack $requestStack, ConfigFactoryInterface $configFactory, StateInterface $state, TimeInterface $time, SpamMasterCollectService $collectService, SpamMasterUserService $userService, SpamMasterApiService $apiService) {
    $this->connection = $connection;
    $this->requestStack = $requestStack;
    $this->configFactory = $configFactory;
    $this->state = $state;
    $this->time = $time;
    $this->collectService = $collectService;
    $this->userService = $userService;
    $this->apiService = $apiService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('database'),
      $container->get('request_stack'),
      $container->get('config.factory'),
      $container->get('state'),
      $container->get('datetime.time'),
      $container->get('spammaster.collect_service'),
      $container->get('spammaster.user_service'),
      $container->get('spammaster.api_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function spamMasterHoneypotCheck($spamFormId, $spammasterip, $spammasteragent, $spammasterextrafield1, $spammasterextrafield2, $spammasterreferer, $spammasterurl, $spammasteruserid) {

    $this->spamFormId = $spamFormId;
    $this->spammasterip = $spammasterip;
    $this->spammasteragent = $spammasteragent;
    $this->spammasterextrafield1 = $spammasterextrafield1;
    $this->spammasterextrafield2 = $spammasterextrafield2;
    $this->spammasterreferer = $spammasterreferer;
    $this->spammasterurl = $spammasterurl;
    $this->spammasteruserid = $spammasteruserid;
    $spammaster_date = date('Y-m-d H:i:s', $this->time->getCurrentTime());
    $spammaster_settings = $this->configFactory->get('spammaster.settings');
    $spammaster_license = $spammaster_settings->get('spammaster.license_key');
    $spammaster_subtype = $spammaster_settings->get('spammaster.subtype');
    $spammaster_status = $this->state->get('spammaster.license_status');
    $spammaster_total_block_count = $this->state->get('spammaster.total_block_count');
    $valid_statuses = ['VALID', 'MALFUNCTION_1', 'MALFUNCTION_2'];

    if (in_array($spammaster_status, $valid_statuses, TRUE) && $spammaster_subtype === 'prod') {
      // Call collect service.
      $collectnow = $this->requestStack->getCurrentRequest()->getClientIp();
      $spammaster_collect_service = $this->collectService;
      $is_collected = $spammaster_collect_service->spamMasterGetCollect($collectnow);
      $spamCollection = Json::decode($is_collected);
      $is_collectedIpHost = $spammaster_collect_service->getIpAndHostname($spamCollection['spammasterurl']);
      $spamCollectionIpHost = Json::decode($is_collectedIpHost);
      // Call user service.
      $spammaster_user_service = $this->userService;
      $is_user = $spammaster_user_service->spamMasterGetUser($spammasteruserid);

      // Insert ip into buffer db.
      $this->connection->insert('spammaster_threats')->fields([
        'date' => $spammaster_date,
        'threat' => $spamCollection['spammasterip'],
      ])->execute();
      // phpcs:ignore DrupalPractice.Variables.GetRequestData.SuperglobalAccessed
      $spampost = $_POST;
      if (!empty($spampost) && is_array($spampost)) {
        $result_post_content_json = Json::encode($spampost);
        $result_post_content_trim = substr($result_post_content_json, 0, 963);
        $result_post_content_clean = strip_tags($result_post_content_trim);
        $result_message_content_trim = 'Form: ' . substr($spamFormId, 0, 85) . ', Field 1: ' . substr($spammasterextrafield1, 0, 85) . ', Field 2: ' . substr($spammasterextrafield2, 0, 85) . ', MSG: ' . substr($result_post_content_clean, 0, 623);
        $result_message_content_clean = strip_tags($result_message_content_trim);
        $spampoststr = str_replace('=', ' ', urldecode(http_build_query($spampost, '', ' ')));
        $spammasteremail = $spammaster_collect_service->extractFirstEmail($spampoststr);
      }
      else {
        $result_post_content_clean = 'empty';
        $result_message_content_clean = 'Form: ' . substr($spamFormId, 0, 85) . ', Field 1: ' . strip_tags(substr($spammasterextrafield1, 0, 85)) . ', Field 2: ' . strip_tags(substr($spammasterextrafield2, 0, 85));
        $spammasteremail = 'haf@' . rand(10000000, 99999999) . '.drup';
      }

      // Web api check. Create data to be posted to verify rbl listings.
      $blog_threat_type = 'honeypot';

      // Call api service.
      $spam_master_leaning_url = 'https://www.spammaster.org/core/learn/get_learn_honey_2.php';

      // Build params.
      $params = [
        'blog_license_key'    => $spammaster_license,
        'blog_threat_ip'      => $spamCollection['spammasterip'],
        'blog_threat_user'    => $is_user,
        'blog_threat_type'    => $blog_threat_type,
        'blog_threat_email'   => $spammasteremail,
        'blog_threat_content' => $result_message_content_clean,
        'blog_threat_agent'   => $spamCollection['spammasteragent'],
        'blog_threat_refe'    => $spamCollection['spammasterreferer'],
        'blog_threat_dest'    => $spamCollection['spammasterurl'],
        'blog_web_adress'     => $spamCollectionIpHost['address'],
        'blog_server_ip'      => $spamCollectionIpHost['ip'],
      ];

      $this->apiService->postScanData($spam_master_leaning_url, $params, FALSE);

      $spammaster_total_block_count_1 = ++$spammaster_total_block_count;
      $this->state->set('spammaster.total_block_count', $spammaster_total_block_count_1);

      $this->connection->insert('spammaster_keys')->fields([
        'date' => $spammaster_date,
        'spamkey' => 'spammaster-honeypot',
        'spamvalue' => 'Spam Master honeypot V2 BLOCK, Field 1: ' . $spammasterextrafield1 . ', Field 2: ' . $spammasterextrafield2 . ', Agent: ' . $spamCollection['spammasteragent'] . ', Email: ' . $spammasteremail . ', IP: ' . $spamCollection['spammasterip'],
      ])->execute();
      throw new AccessDeniedHttpException();
    }
  }

}
