<?php

namespace Drupal\spammaster\Controller;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Database\Connection;
use Drupal\Core\State\StateInterface;
use Drupal\spammaster\SpamMasterActionService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Class controller.
 */
class SpamMasterActionController extends ControllerBase {

  /**
   * The database connection object.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $connection;

  /**
   * Symfony\Component\HttpFoundation\RequestStack definition.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * The Config Factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The state.
   *
   * @var \Drupal\Core\State\StateInterface
   */
  protected $state;

  /**
   * The SpamMasterActionService Service.
   *
   * @var \Drupal\spammaster\SpamMasterActionService
   */
  protected $actionService;

  /**
   * {@inheritdoc}
   */
  public function __construct(Connection $connection, RequestStack $requestStack, ConfigFactoryInterface $configFactory, StateInterface $state, SpamMasterActionService $actionService) {
    $this->connection = $connection;
    $this->requestStack = $requestStack;
    $this->configFactory = $configFactory;
    $this->state = $state;
    $this->actionService = $actionService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('database'),
      $container->get('request_stack'),
      $container->get('config.factory'),
      $container->get('state'),
      $container->get('spammaster.action_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function spamMasterToAct(): JsonResponse {
    $spammaster_settings = $this->configFactory->get('spammaster.settings');
    $spammaster_license = $spammaster_settings->get('spammaster.license_key');
    $spammaster_db_protection_hash = $this->state->get('spammaster.spam_master_db_protection_hash');
    $this->state->set('spammaster.new_options', '1');
    $spamPost = $this->requestStack->getCurrentRequest();
    $spamMethod = $spamPost->getMethod();
    if ('POST' !== $spamMethod) {
      return $this->jsonError($this->t('Not able to proceed in fifth order.'), 401);
    }
    $spamContent = $spamPost->getContent();
    $spamParams = json_decode($spamContent, TRUE);
    if (!is_array($spamParams) || !isset($spamParams['k'], $spamParams['h'])) {
      return $this->jsonError($this->t('Not able to proceed in forth order.'), 401);
    }
    $spammasterOne = htmlentities($spamParams['k'], ENT_QUOTES, 'UTF-8');
    $spammasterTwo = htmlentities($spamParams['h'], ENT_QUOTES, 'UTF-8');
    $spammasterThree = isset($spamParams['v']) ? htmlentities($spamParams['v'], ENT_QUOTES, 'UTF-8') : '0';
    if (empty($spammasterOne)) {
      return $this->jsonError($this->t('Silence is Golden. Request k.'), 401);
    }
    if (empty($spammasterTwo)) {
      return $this->jsonError($this->t('Silence is Golden. Request h.'), 401);
    }
    if (!empty($spammasterOne) && !empty($spammasterTwo) && '0' === $spammasterThree) {
      if ($spammasterOne == $spammaster_license && $spammasterTwo == $spammaster_db_protection_hash) {
        $spama = '1';
        $spammaster_action_service = $this->actionService;
        $spammaster_action_service->spamMasterAct($spama);
        return new JsonResponse([
          'message' => $this->t('Successful Transfer.'),
          'status' => 200,
        ], 200);
      }
      else {
        return $this->jsonError($this->t('Not able to proceed in second order.'), 401);
      }
    }
    if (!empty($spammasterOne) && !empty($spammasterTwo) && '1' === $spammasterThree) {
      if ($spammasterOne == $spammaster_license && $spammasterTwo == $spammaster_db_protection_hash) {
        $exempt_count = [];
        $spammaster_version = $this->state->get('spammaster.version');
        $db_install_version = $this->state->get('spammaster.db_install_version');
        $spammaster_subtype = $spammaster_settings->get('spammaster.subtype');
        $exempt_count['Statistics'][] = [
          'Version'  => $spammaster_version . '-' . $db_install_version . '-' . $spammaster_subtype,
        ];
        $spammaster_status = $this->state->get('spammaster.license_status');
        $exempt_count['Statistics'][] = [
          'Status'  => $spammaster_status,
        ];
        $spammaster_settings_protection = $this->configFactory->get('spammaster.settings_protection');
        $basic_firewall_rules = $spammaster_settings_protection->get('spammaster.basic_firewall_rules');
        $exempt_count['Statistics'][] = [
          'Firewall'  => $basic_firewall_rules,
        ];
        $spam_master_is_cloudflare = $spammaster_settings_protection->get('spammaster.spam_master_is_cloudflare');
        $exempt_count['Statistics'][] = [
          'CDN'  => $spam_master_is_cloudflare,
        ];
        $spammaster_buffer_count = $this->connection->select('spammaster_threats', 'u')
          ->fields('u', ['threat'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'Buffer'  => $spammaster_buffer_count,
        ];
        $spammaster_white_count = $this->connection->select('spammaster_white', 'u')
          ->fields('u', ['white'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'White'  => $spammaster_white_count,
        ];
        $spammaster_exempt_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', '%' . $this->connection->escapeLike('exempt') . '%', 'LIKE')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'Needles'  => $spammaster_exempt_count,
        ];
        $spammaster_keys_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', '%' . $this->connection->escapeLike('exempt') . '%', 'NOT LIKE')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'Keys'  => $spammaster_keys_count,
        ];
        $spammaster_white_transient = $this->state->get('spammaster.white_transient');
        $spammaster_wth_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'white-transient-haf', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $spammaster_wtf_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'white-transient-form', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'White Tran'  => $spammaster_white_transient,
          'White TranH' => $spammaster_wth_count,
          'White TranF' => $spammaster_wtf_count,
        ];
        $flood_control = $spammaster_settings_protection->get('spammaster.flood_control');
        $flood_control_window = $spammaster_settings_protection->get('spammaster.flood_control_window');
        $flood_control_limit = $spammaster_settings_protection->get('spammaster.flood_control_limit');
        $flood_control_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'post-flood', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'Flood Control' => $flood_control,
          'Flood Window'  => $flood_control_window,
          'Flood Limit'   => $flood_control_limit,
          'Flood Count'   => $flood_control_count,
        ];
        $cleanup_firewall = $spammaster_settings_protection->get('spammaster.cleanup_firewall');
        $cleanup_firewall_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-firewall', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_honeypot = $spammaster_settings_protection->get('spammaster.cleanup_honeypot');
        $cleanup_honeypot_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-honeypot', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_whitelist = $spammaster_settings_protection->get('spammaster.cleanup_whitelist');
        $cleanup_whitelist_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-whitelist', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_system = $spammaster_settings_protection->get('spammaster.cleanup_system');
        $cleanup_system_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_license_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-license', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_mail = $spammaster_settings_protection->get('spammaster.cleanup_mail');
        $cleanup_mail_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-mail', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $cleanup_cron = $spammaster_settings_protection->get('spammaster.cleanup_cron');
        $cleanup_cron_count = $this->connection->select('spammaster_keys', 'u')
          ->condition('u.spamkey', 'spammaster-cron', '=')
          ->fields('u', ['spamkey'])
          ->countQuery()->execute()->fetchField();
        $exempt_count['Statistics'][] = [
          'Clean FirD'  => $cleanup_firewall,
          'Clean FirT'  => $cleanup_firewall_count,
          'Clean HonD'  => $cleanup_honeypot,
          'Clean HonT'  => $cleanup_honeypot_count,
          'Clean WhiD'  => $cleanup_whitelist,
          'Clean WhiT'  => $cleanup_whitelist_count,
          'Clean SysD'  => $cleanup_system,
          'Clean SysT'  => $cleanup_system_count,
          'Clean LicT'  => $cleanup_license_count,
          'Clean MaiD'  => $cleanup_mail,
          'Clean MaiT'  => $cleanup_mail_count,
          'Clean CroD'  => $cleanup_cron,
          'Clean CroT'  => $cleanup_cron_count,
        ];
        $exempt_needle = [];
        $spamFormIdnee = 'search_form';
        $spammaster_test_exempt_needle = $this->connection->query("SELECT spamvalue FROM {spammaster_keys} WHERE spamkey = :key AND POSITION(spamvalue IN :exclude) > :value", [
          ':key' => 'exempt-needle',
          ':exclude' => $spamFormIdnee,
          ':value' => 0,
        ])->fetchField();
        if (!empty($spammaster_test_exempt_needle)) {
          $exempt_needle['Exempt-Needles']['Locate'] = [
            'Value'  => 'search',
            'String' => $spamFormIdnee,
            'Result' => 'Found: ' . $spammaster_test_exempt_needle,
          ];
        }
        else {
          $exempt_needle['Exempt-Needles']['Locate'] = [
            'Value'  => 'search',
            'String' => $spamFormIdnee,
            'Result' => 'Not Found needle search',
          ];
        }
        $spammaster_exempt_needle = $this->connection->query("SELECT * FROM {spammaster_keys} WHERE spamkey = :key", [
          ':key' => 'exempt-needle',
        ])->fetchAll();
        if (!empty($spammaster_exempt_needle)) {
          foreach ($spammaster_exempt_needle as $needle) {
            $spam_id = $needle->id;
            $spam_time = $needle->date;
            $spam_key = $needle->spamkey;
            $spam_value = $needle->spamvalue;
            $exempt_needle['Exempt-Needles'][] = [
              'id'        => $spam_id,
              'date'      => $spam_time,
              'spamkey'   => $spam_key,
              'spamvalue' => $spam_value,
            ];
          }
        }
        $exempt_key = [];
        $spampostarrkey = [
          'edit_quantity' => [
            '1',
            '2',
            '1',
          ],
          'form_build_id' => 'form-PSKMo16jLsqm_h6fhl35FI8BacqHmrX4jf3j_zhQ8do',
          'form_id' => 'views_form_commerce_cart_form_default_19728',
          'coupon_redemption' => [
            'code' => 'WBqFg65oFd',
            'url' => '',
            '_triggering_element_name' => 'apply_coupon',
          ],
          '_drupal_ajax' => '1',
        ];
        $spampoststrkey = str_replace('=', ' ', urldecode(http_build_query($spampostarrkey, '', ' ')));
        $spammaster_test_exempt_key = $this->connection->query("SELECT spamvalue FROM {spammaster_keys} WHERE spamkey = :key AND POSITION(spamvalue IN :exclude) > :value", [
          ':key' => 'exempt-key',
          ':exclude' => $spampoststrkey,
          ':value' => 0,
        ])->fetchField();
        if (!empty($spammaster_test_exempt_key)) {
          $exempt_key['Exempt-Keys']['Locate'] = [
            'Value'  => 'edit_quantity',
            'String' => $spampoststrkey,
            'Result' => 'Found: ' . $spammaster_test_exempt_key,
          ];
        }
        else {
          $exempt_key['Exempt-Keys']['Locate'] = [
            'Value'  => 'edit_quantity',
            'String' => $spampoststrkey,
            'Result' => 'Not Found key edit_quantity',
          ];
        }
        $spammaster_exempt_key = $this->connection->query("SELECT * FROM {spammaster_keys} WHERE spamkey = :key", [
          ':key' => 'exempt-key',
        ])->fetchAll();
        if (!empty($spammaster_exempt_key)) {
          foreach ($spammaster_exempt_key as $key) {
            $spam_id = $key->id;
            $spam_time = $key->date;
            $spam_key = $key->spamkey;
            $spam_value = $key->spamvalue;
            $exempt_key['Exempt-Keys'][] = [
              'id'        => $spam_id,
              'date'      => $spam_time,
              'spamkey'   => $spam_key,
              'spamvalue' => $spam_value,
            ];
          }
        }
        $exempt_value = [];
        $spampostarrval = [
          'edit_quantity' => [
            '1',
            '2',
            '1',
          ],
          'form_build_id' => 'form-PSKMo16jLsqm_h6fhl35FI8BacqHmrX4jf3j_zhQ8do',
          'form_id' => 'views_form_commerce_cart_form_default_19728',
          'coupon_redemption' => [
            'code' => 'WBqFg65oFd',
            'url' => '',
            '_triggering_element_name' => 'commerce_wishlist',
          ],
          '_drupal_ajax' => '1',
        ];
        $spampoststrval = str_replace('=', ' ', urldecode(http_build_query($spampostarrval, '', ' ')));
        $spammaster_test_exempt_value = $this->connection->query("SELECT spamvalue FROM {spammaster_keys} WHERE spamkey = :key AND POSITION(spamvalue IN :exclude) > :value", [
          ':key' => 'exempt-value',
          ':exclude' => $spampoststrval,
          ':value' => 0,
        ])->fetchField();
        if (!empty($spammaster_test_exempt_value)) {
          $exempt_value['Exempt-Values']['Locate'] = [
            'Value'  => 'commerce_wishlist',
            'String' => $spampoststrval,
            'Result' => 'Found: ' . $spammaster_test_exempt_value,
          ];
        }
        else {
          $exempt_value['Exempt-Values']['Locate'] = [
            'Value'  => 'commerce_wishlist',
            'String' => $spampoststrval,
            'Result' => 'Not Found key edit_quantity',
          ];
        }
        $spammaster_exempt_value = $this->connection->query("SELECT * FROM {spammaster_keys} WHERE spamkey = :key", [
          ':key' => 'exempt-value',
        ])->fetchAll();
        if (!empty($spammaster_exempt_value)) {
          foreach ($spammaster_exempt_value as $value) {
            $spam_id = $value->id;
            $spam_time = $value->date;
            $spam_key = $value->spamkey;
            $spam_value = $value->spamvalue;
            $exempt_value['Exempt-Values'][] = [
              'id'        => $spam_id,
              'date'      => $spam_time,
              'spamkey'   => $spam_key,
              'spamvalue' => $spam_value,
            ];
          }
        }
        $exempt_result = [
          $exempt_count,
          $exempt_needle,
          $exempt_key,
          $exempt_value,
        ];
        return new JsonResponse([
          'Exemptions' => $exempt_result,
          'status' => 200,
        ], 200);
      }
      else {
        return $this->jsonError($this->t('Not able to proceed in third order.'), 401);
      }
    }
    return $this->jsonError($this->t('Not able to proceed in forth order.'), 401);
  }

  /**
   * {@inheritdoc}
   */
  private function jsonError(string $message, int $status): JsonResponse {
    return new JsonResponse([
      'error' => $message,
      'status' => $status,
    ], $status);
  }

}
