<?php

declare(strict_types=1);

namespace Drupal\Tests\spamspan\Functional;

use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\SchemaCheckTestTrait;

/**
 * Tests spamspan email formatter functionality.
 *
 * @group spamspan
 * @covers \Drupal\spamspan\Plugin\Field\FieldFormatter\EmailSpamspanFormatter
 */
class EmailSpamSpanFormatterTest extends BrowserTestBase {

  use SchemaCheckTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'field_ui',
    'spamspan',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->createContentType(['type' => 'article']);

    // Create an email field.
    $field_name = 'spamspan_email';
    $field_storage = FieldStorageConfig::create([
      'field_name' => $field_name,
      'entity_type' => 'node',
      'type' => 'email',
    ]);
    $field_storage->save();
    $field = FieldConfig::create([
      'field_storage' => $field_storage,
      'bundle' => 'article',
    ]);
    $field->save();

    // Update a form and view displays.
    /** @var \Drupal\Core\Entity\EntityDisplayRepositoryInterface $display_repository */
    $display_repository = \Drupal::service('entity_display.repository');
    $display_repository->getFormDisplay('node', 'article')
      ->setComponent($field_name, ['type' => 'email_default'])
      ->save();
    $display_repository->getViewDisplay('node', 'article')
      ->setComponent($field_name, ['type' => 'email_spamspan'])
      ->save();
  }

  /**
   * Tests email field formatter.
   */
  public function testEmailField(): void {
    $node = $this->createNode([
      'type' => 'article',
      'title' => 'test123',
      'spamspan_email' => 'mailto:example@email.com',
    ]);
    $node->save();

    // Go to the node, and see if the mail link is displayed correctly.
    $session = $this->assertSession();
    $this->drupalGet('/node/' . $node->id());
    $session->statusCodeEquals(200);
    $session->elementExists('css', 'span.spamspan');
    $session->elementTextEquals('css', 'span.spamspan', 'example [at] email.com');
  }

  /**
   * Tests the config schema for the filter format.
   */
  public function testConfigSchema(): void {
    $config = $this->config('core.entity_view_display.node.article.full');
    $this->assertConfigSchema(\Drupal::service('config.typed'), 'core.entity_view_display.node.article.full', $config->get());
  }

}
