(function (Drupal, drupalSettings, once) {
  "use strict";

  Drupal.behaviors.speakeasySettings = {
    attach: function (context) {
      once('speakeasySettings', 'body', context).forEach(function () {
        if (!window.speechSynthesis) {
          console.error('Speech Synthesis API not supported in this browser.');
          return;
        }

        const synth = window.speechSynthesis;
        let voices = [];

        const loadVoices = () => {
          voices = synth.getVoices();
          console.log('Voices loaded:', voices);
          if (voices.length === 0) {
            setTimeout(loadVoices, 100); // Retry if voices aren’t loaded yet
            return;
          }

          const voicesData = voices.map(voice => ({
            name: voice.name,
            lang: voice.lang,
            default: voice.default,
          }));

          // Store voices in the hidden field.
          const voicesField = document.getElementById('speakeasy-current-voices');
          if (voicesField) {
            voicesField.value = JSON.stringify(voicesData);
          }

          // Fetch CSRF token and send voices.
          fetch(Drupal.url('session/token'), {
            method: 'GET',
            credentials: 'same-origin',
          })
          .then(response => response.text())
          .then(csrfToken => {
            console.log('CSRF Token:', csrfToken);
            return fetch(Drupal.url('speakeasy/store-voices'), {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-Token': csrfToken,
              },
              body: JSON.stringify({ voices: voicesData }),
            });
          })
          .then(response => response.json())
          .then(data => console.log('Voice storage response:', data))
          .catch(error => console.error('Error storing voices:', error));
        };

        if (synth.onvoiceschanged !== undefined) {
          synth.onvoiceschanged = loadVoices;
        }
        loadVoices();
      });
    }
  };
})(Drupal, drupalSettings, once);
