(function (Drupal, once) {
  'use strict';
  Drupal.behaviors.speakeasyAdmin = {
    attach: function (context) {
      once('speakeasy-select-all', '.speakeasy-select-all-languages', context).forEach(function (checkbox) {
        const wrapper = context.querySelector('.speakeasy-language-checkboxes');
        if (!wrapper) {
          return;
        }
        const checkboxes = wrapper.querySelectorAll('input[type="checkbox"]');
        checkbox.addEventListener('change', function () {
          const checked = this.checked;
          checkboxes.forEach(function (cb) {
            cb.checked = checked;
          });
        });
      });
    }
  };
})(Drupal, once);
