(function (Drupal, drupalSettings, once) {
  'use strict';

  Drupal.behaviors.speakeasyUserPreferences = {
    attach: function (context) {
      once('speakeasyUserPreferences', '#speakeasy-user-voice-select', context).forEach(function (select) {
        if (!window.speechSynthesis) {
          Drupal.announce(Drupal.t('Speech Synthesis API not supported in this browser.'));
          return;
        }

        Drupal.speakeasyVoice.loadVoices().then(({ voices, defaultVoice }) => {
          select.innerHTML = '';
          const defaultOption = document.createElement('option');
          defaultOption.value = '';
          defaultOption.textContent = Drupal.t('- Browser default -');
          select.appendChild(defaultOption);

          voices.forEach((voice) => {
            const option = document.createElement('option');
            option.value = voice.name;
            option.textContent = `${voice.name} (${voice.lang})`;
            select.appendChild(option);
          });

          if (defaultVoice && voices.some(v => v.name === defaultVoice)) {
            select.value = defaultVoice;
          }
        });

        select.addEventListener('change', () => {
          Drupal.speakeasyVoice.applyVoice(select.value);
        });
      });
    }
  };
})(Drupal, drupalSettings, once);
