(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.speakeasyUtils = Drupal.speakeasyUtils || {};

  Drupal.speakeasyUtils.markSpeakeasyFields = function () {
    const fieldNames = Array.isArray(drupalSettings.speakeasy && drupalSettings.speakeasy.fieldNames)
      ? drupalSettings.speakeasy.fieldNames
      : [];
    fieldNames.forEach((field) => {
      const classSelector = '.field--name-' + field.replace(/_/g, '-');
      document.querySelectorAll(classSelector).forEach((el) => {
        el.setAttribute('data-speakeasy-field', field);
      });
    });
  };
})(Drupal, drupalSettings);
