(function (Drupal) {
  const { EVENTS, PLAYER_STATES } = Drupal.speakeasyConstants;
  const subscribers = {};
  let playerState = PLAYER_STATES.IDLE;

  function subscribe(event, callback) {
    if (!subscribers[event]) {
      subscribers[event] = [];
    }
    subscribers[event].push(callback);
    return () => {
      subscribers[event] = subscribers[event].filter((cb) => cb !== callback);
    };
  }

  function dispatch(event, detail = {}) {
    switch (event) {
      case EVENTS.PAUSE:
        playerState = PLAYER_STATES.PAUSED;
        break;
      case EVENTS.RESUME:
      case EVENTS.SENTENCE_START:
        playerState = PLAYER_STATES.PLAYING;
        break;
      case EVENTS.STOP:
        playerState = PLAYER_STATES.IDLE;
        break;
      default:
        break;
    }
    (subscribers[event] || []).forEach((cb) => cb({ type: event, detail }));
  }

  Drupal.speakeasyBus = {
    subscribe,
    dispatch,
    get playerState() {
      return playerState;
    },
  };
})(Drupal);
