<?php

declare(strict_types=1);

namespace Drupal\speedboxes\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook help.
 */
class Help {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function helpHook(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.speedboxes':
        $output = '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('Allows for the checking and unchecking of multiple checkboxes with a drag and drop interface.') . '</p>';
        return $output;
    }

    return NULL;
  }

}
