<?php

namespace Drupal\sphoenix_ai\Service;

/**
 * Constants service for SPhoenix AI, similar to VS Code extension constants.
 */
class Constants
{

  // Hardcoded Tool ID (like VS Code extension)
  const TOOL_ID = 'd33250f0-40e4-45b4-b802-67c6b84235f3';

  // Default API Configuration
  const DEFAULT_API_BASE_URL = 'https://api.sphoenixai.com/v1/v1';
  const DEFAULT_FRONTEND_URL = 'https://www.sphoenixai.com';

  // API Endpoints
  const ENDPOINTS = [
    'CMS_CHAT' => '/cms-module/cms-chat',
    'AUTH_CHECK' => '/auth/is-autherized',
    'USER_PROFILE' => '/user/profile',
    'SUBSCRIPTION' => '/subscriptions/get-user-subscription',
    'AUTH_LOGIN' => '/auth/login',
    'AUTH_REFRESH' => '/auth/refresh',
    'AUTH_LOGOUT' => '/auth/logout',
  ];

  // Frontend Routes
  const FRONTEND_ROUTES = [
    'LOGIN' => '/cms-login',
    'SIGNUP' => '/cms-login',
    'PLANS' => '/plans-catalog?category=cms',
  ];

  // Default Configuration Values
  const DEFAULT_TEMPERATURE = 0.7;
  const DEFAULT_WORD_LENGTH = 600;
  const DEFAULT_PARAGRAPHS = 4;
  const DEFAULT_TONE = 'conversational';

  /**
   * Get API base URL from configuration or default.
   */
  public static function getApiBaseUrl(): string
  {
    return self::DEFAULT_API_BASE_URL;
  }

  /**
   * Get frontend base URL from configuration or default.
   */
  public static function getFrontendBaseUrl(): string
  {
    return self::DEFAULT_FRONTEND_URL;
  }

  /**
   * Get full endpoint URL.
   */
  public static function getEndpointUrl(string $endpoint): string
  {
    return self::getApiBaseUrl() . self::ENDPOINTS[$endpoint];
  }

  /**
   * Get frontend route URL.
   */
  public static function getFrontendRouteUrl(string $route): string
  {
    return self::getFrontendBaseUrl() . self::FRONTEND_ROUTES[$route];
  }

  /**
   * Get plans page URL.
   */
  public static function getPlansUrl(): string
  {
    return self::getFrontendRouteUrl('PLANS');
  }

  /**
   * Get login URL with callback.
   */
  public static function getLoginUrl(string $callback_url = ''): string
  {
    $login_url = self::getFrontendRouteUrl('LOGIN');

    if ($callback_url) {
      $params = [
        'redirect_uri' => $callback_url,
        'source' => 'drupal',
      ];
      $login_url .= '?' . http_build_query($params);
    }

    return $login_url;
  }

  public static function getSignupUrl(): string
  {
    return self::getFrontendBaseUrl() . self::FRONTEND_ROUTES['SIGNUP'];
  }
}
