<?php

namespace Drupal\Tests\splide\Kernel\Form;

use Drupal\Core\Form\FormInterface;
use Drupal\Core\Form\FormState;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\splide\Traits\SplideKernelTrait;
use Drupal\splide_ui\Form\SplideSettingsForm;

/**
 * Tests the Splide UI settings form.
 */
/**
 * A D12 compat, please update or ignore.
 *
 * @phpstan-ignore-next-line
 */
#[Group('blazy')]
/**
 * A D12 compat, please update or ignore.
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class SplideSettingsFormTest extends KernelTestBase {

  use SplideKernelTrait;

  /**
   * The splide settings form object under test.
   *
   * @var \Drupal\splide_ui\Form\SplideSettingsForm
   */
  protected $splideSettingsForm;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'system',
    'file',
    'image',
    'media',
    'user',
    'blazy',
    'splide',
    'splide_ui',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installSchema('file', ['file_usage']);
    $this->installEntitySchema('file');
    $this->installEntitySchema('media');
    $this->installEntitySchema('user');

    $this->installConfig('image');
    $this->installConfig('media');
    $this->installConfig('system');

    $this->installConfig([
      'blazy',
      'splide',
    ]);

    $this->splideManager = $this->container->get('splide.manager');

    $this->splideSettingsForm = SplideSettingsForm::create($this->container);
  }

  /**
   * Tests for \Drupal\splide_ui\Form\SplideSettingsForm.
   */
  public function testSplideSettingsForm() {
    // Emulate a form state of a submitted form.
    $form_state = (new FormState())->setValues([
      'module_css' => TRUE,
    ]);

    $this->assertInstanceOf(FormInterface::class, $this->splideSettingsForm);
    $this->assertTrue($this->splideManager->configFactory()->get('splide.settings')->get('module_css'));

    $id = $this->splideSettingsForm->getFormId();
    $this->assertEquals('splide_settings_form', $id);

    $method = new \ReflectionMethod(SplideSettingsForm::class, 'getEditableConfigNames');
    $method->setAccessible(TRUE);

    $name = $method->invoke($this->splideSettingsForm);
    $this->assertEquals(['splide.settings'], $name);

    $form = $this->splideSettingsForm->buildForm([], $form_state);
    $this->splideSettingsForm->submitForm($form, $form_state);
  }

}
