(function ($, Drupal, once) {
  Drupal.behaviors.splunk_rum = {
    attach: function(context, settings) {
      const splunkRumSettings = drupalSettings.splunkRum;

      if (SplunkRum !== undefined && splunkRumSettings.enabled) {
        once('splunkRum', 'html').forEach(function() {
          SplunkRum.init({
            realm: splunkRumSettings.realm,
            rumAccessToken: splunkRumSettings.accessToken,
            applicationName: splunkRumSettings.applicationName,
            deploymentEnvironment: splunkRumSettings.deploymentEnvironment,
          });
        })
      }
    }
  }
})(jQuery, Drupal, once)

