<?php

namespace Drupal\splunk_rum\Form;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure the Splunk Real User Monitoring script.
 */
class SplunkRumConfigForm extends ConfigFormBase {

  /**
   * A 'splunk_rum.settings' config instance.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected Config $settings;

  /**
   * Constructs a SplunkRumConfigForm object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   * @param \Drupal\Core\Config\TypedConfigManagerInterface $typedConfigManager
   *   The typed config manager.
   */
  public function __construct(ConfigFactoryInterface $config_factory, TypedConfigManagerInterface $typedConfigManager) {
    parent::__construct($config_factory, $typedConfigManager);
    $this->settings = $config_factory->getEditable('splunk_rum.settings');
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'splunk_rum_configure';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['splunk_rum.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable the Real User Monitoring script for your site'),
      '#default_value' => $this->settings->get('enabled'),
      '#description' => $this->t('When enabled the script for Real User Monitoring will be added to your site.'),
    ];

    $form['version'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Script version'),
      '#default_value' => $this->settings->get('version'),
      '#description' => $this->t('Version for the script'),
    ];

    $form['realm'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Realm'),
      '#default_value' => $this->settings->get('realm'),
      '#description' => $this->t('Realm'),
    ];

    $form['accesstoken'] = [
      '#type' => 'textfield',
      '#title' => $this->t('RUM access token'),
      '#default_value' => $this->settings->get('accesstoken'),
      '#description' => $this->t('RUM access token'),
    ];

    $form['applicationname'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Application name'),
      '#default_value' => $this->settings->get('applicationname'),
      '#description' => $this->t('Application name'),
    ];

    $form['deployment_environment'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Deployment environment'),
      '#default_value' => $this->settings->get('deployment_environment'),
      '#description' => $this->t('Deployment environment'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $enabled = $form_state->getValue('enabled');
    $version = $form_state->getValue('version');
    $realm = $form_state->getValue('realm');
    $accesstoken = $form_state->getValue('accesstoken');
    $applicationname = $form_state->getValue('applicationname');
    $deployment_environment = $form_state->getValue('deployment_environment');

    /* Save the configuration */
    $this->settings
      ->set('enabled', $enabled)
      ->set('version', $version)
      ->set('realm', $realm)
      ->set('accesstoken', $accesstoken)
      ->set('applicationname', $applicationname)
      ->set('deployment_environment', $deployment_environment)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
