(function (Drupal, once) {
  Drupal.behaviors.spotifySlider = {
    attach: function (context) {
      once('spotifySlider', '.spotify-slider', context).forEach(function(sliderWrapper) {
        const slider = sliderWrapper.querySelector('.spotify-items');
        if (!slider) return;

        const prev = document.createElement('button');
        const next = document.createElement('button');
        prev.className = 'spotify-prev';
        next.className = 'spotify-next';
        prev.innerHTML = '‹';
        next.innerHTML = '›';
        sliderWrapper.appendChild(prev);
        sliderWrapper.appendChild(next);

        prev.addEventListener('click', () => {
          slider.scrollBy({ left: -slider.offsetWidth, behavior: 'smooth' });
        });
        next.addEventListener('click', () => {
          slider.scrollBy({ left: slider.offsetWidth, behavior: 'smooth' });
        });
      });
    }
  };
})(Drupal, once);
