<?php

/**
 * @file
 * Views hooks for the SQL View module.
 */

declare(strict_types=1);

use Drupal\sql_views\SqlViewInterface;

/**
 * Implements hook_views_data().
 */
function sql_views_views_data(): array {
  $manager = \Drupal::service('plugin.manager.sql_view');
  $data = [];
  foreach ($manager->getSupportedDefinitions() as $plugin_id => $definition) {
    $sql_view = $manager->createInstance($plugin_id);
    \assert($sql_view instanceof SqlViewInterface);
    $data[$manager::getViewName($plugin_id)] = $sql_view->getViewsData();
  }
  return $data;
}
