<?php

declare(strict_types=1);

namespace Drupal\sql_views\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup as TM;

/**
 * The sql_view attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class SqlView extends AttributeBase {

  /**
   * Constructs a new SqlView instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   (optional) The human-readable name of the plugin.
   * @param string[]|null $supportedDrivers
   *   (optional) List of supported database drivers or null if all drivers are
   *   supported.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TM $label,
    public readonly ?array $supportedDrivers = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
