<?php

declare(strict_types=1);

namespace Drupal\sql_views\Command;

use Drupal\sql_views\SqlViewPluginManager;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * {@selfdoc}
 */
#[AsCommand(
  name: 'sql:views:rebuild',
  description: 'Rebuilds all SQL views',
)]
final class RebuildCommand extends Command {

  /**
   * {@inheritdoc}
   */
  public function __construct(private readonly SqlViewPluginManager $viewManager) {
    parent::__construct();
  }

  /**
   * @return int<0, 0>
   */
  protected function execute(InputInterface $input, OutputInterface $output): int {
    $this->viewManager->rebuild();
    (new SymfonyStyle($input, $output))->success('Done');
    return self::SUCCESS;
  }

}
