<?php

declare(strict_types=1);

namespace Drupal\sql_views;

use Drupal\Core\Database\Query\SelectInterface;

/**
 * Interface for sql_view plugins.
 */
interface SqlViewInterface {

  /**
   * Returns select query for a view.
   */
  public function getQuery(): string|SelectInterface;

  /**
   * Describes the virtual table and fields to Views.
   *
   * @see \hook_views_data()
   */
  public function getViewsData(): array;

}
