<?php

declare(strict_types=1);

namespace Drupal\sql_views;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Database\Connection;
use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for sql_view plugins.
 */
abstract class SqlViewPluginBase extends PluginBase implements SqlViewInterface, ContainerFactoryPluginInterface {

  /**
   * {@selfdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, protected Connection $database) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    // @phpstan-ignore-next-line
    return new static(
      configuration: $configuration,
      plugin_id: $plugin_id,
      plugin_definition: $plugin_definition,
      database: $container->get('database')
    );
  }

  /**
   * {@inheritdoc}
   */
  abstract public function getQuery(): string|SelectInterface;

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    return [];
  }

}
