## INTRODUCTION

The SQLite Backup module is only useful if your database is using sqlite.

The primary use case for this module is:

- Allow experimentation with recipes, content changes and other things that might be hard to undo.

It is worth noting that the operations the module performs could also be done
manually. To minimize the risk of the freshly restored backup getting corrupted
by database operations that were meant for the old sqlite file, there should not
be concurrent requests to the database.
Another important observation is that when the backup is restored the current
user may be logged out. But more importantly if the code base changed since the
backup was created, database updates may be necessary.

## REQUIREMENTS

sqlite: The sqlite database driver must be used for the default database.
The module can be installed on sites with other database drivers, but then it can not do anything useful.

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## CONFIGURATION
- Go to /admin/config/development/sqlite-backup to manage the backups.
- The module manages the backups in a metadata file located in the same folder as the sqlite database.

## MAINTAINERS

Current maintainers for Drupal 11:

- Fabian Bircher (bircher) - https://www.drupal.org/u/bircher

