<?php

namespace Drupal\sqlite_backup\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * The ajax command for waiting a moment.
 */
class WaitCommand implements CommandInterface {

  /**
   * Constructs an WaitCommand object.
   *
   * @param int $seconds
   *   The amount of seconds to wait.
   */
  public function __construct(
    protected readonly int $seconds = 1,
  ) {}

  /**
   * Implements Drupal\Core\Ajax\CommandInterface:render().
   */
  public function render() {
    return [
      'command' => 'sqliteBackupWait',
      'seconds' => $this->seconds,
    ];
  }

}
