<?php

namespace Drupal\sqlite_backup;

/**
 * A value object representing a SQLite backup.
 *
 * @internal
 *   This API is experimental.
 */
final class SqliteBackup {

  public function __construct(
    public readonly string $id,
    public readonly \Stringable|string $label,
    public readonly int $timestamp,
    public readonly string $file,
  ) {}

  /**
   * Create a backup value object from an array.
   *
   * @param string $id
   *   The id.
   * @param array $data
   *   The data of the backup.
   *
   * @return static
   *   The backup value object
   */
  public static function fromArray(string $id, array $data): static {
    return new static(
      id: $id,
      label: $data['name'],
      timestamp: $data['time'],
      file: $data['file'],
    );
  }

  /**
   * Get the data of the value object.
   *
   * @return array
   *   The array representation.
   */
  public function toArray(): array {
    return [
      'name' => (string) $this->label,
      'file' => $this->file,
      'time' => $this->timestamp,
    ];
  }

}
