<?php

namespace Drupal\Tests\sqlsrv\Kernel;

/**
 * Tests new database creation and configuration.
 *
 * @group Database
 */
class NewDatabaseTest extends SqlsrvTestBase {

  /**
   * The sqlsrv schema.
   *
   * @var \Drupal\sqlsrv\Driver\Database\sqlsrv\Schema
   */
  protected $schema;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    // Skip test if SQL Server PDO extension is not available.
    // Check this BEFORE modifying any environment variables.
    if (!extension_loaded('pdo_sqlsrv')) {
      // Call parent first to initialize test state.
      parent::setUp();
      $this->markTestSkipped('This test requires pdo_sqlsrv PHP extension.');
      return;
    }

    // Parse credentials from SIMPLETEST_DB or environment variables.
    // We need to do this before parent::setUp() because
    // getSqlServerCredentials() is a method that requires the test setup.
    $simpletest_db = getenv('SIMPLETEST_DB');
    if ($simpletest_db) {
      $parsed = parse_url($simpletest_db);
      $host = $parsed['host'] ?? 'sqlsrv';
      $username = $parsed['user'] ?? 'sa';
      $password = $parsed['pass'] ?? '';
    }
    else {
      $host = getenv('SQLSRV_TEST_HOST') ?: 'sqlsrv';
      $username = getenv('SQLSRV_TEST_USERNAME') ?: 'sa';
      $password = getenv('SQLSRV_TEST_PASSWORD') ?: '';
    }

    // Build connection string for new database test.
    $connection_string = sprintf(
      'sqlsrv://%s:%s@%s/newdrupalsite?schema=dbo&cache_schema=true&module=sqlsrv&trust_server_certificate=true',
      $username,
      $password,
      $host
    );
    \putenv("SIMPLETEST_DB=$connection_string");
    parent::setUp();

    /** @var \Drupal\sqlsrv\Driver\Database\sqlsrv\Schema $schema */
    $schema = $this->connection->schema();
    $this->schema = $schema;
  }

  /**
   * Tests that the database name is correctly set.
   */
  public function testDatabaseName() {
    $options = $this->connection->getConnectionOptions();
    $db = $options['database'];
    $this->assertEquals($db, 'newdrupalsite');
  }

  /**
   * Test the collation of a new database.
   *
   * @covers \Drupal\sqlsrv\Driver\Database\sqlsrv\Schema::getCollation
   */
  public function testCollation() {
    $collation = $this->schema->getCollation();
    $this->assertStringContainsString('CI', $collation);
  }

}
