CREATE FUNCTION [dbo].[REGEXP](@pattern NVARCHAR(4000), @matchString NVARCHAR(4000))
RETURNS bit AS
BEGIN
  DECLARE @result bit = 0

  -- Handle NULL inputs
  IF @pattern IS NULL OR @matchString IS NULL
    RETURN 0

  -- Handle empty pattern (matches everything)
  IF LEN(@pattern) = 0
    RETURN 1

  -- Handle start anchor (^)
  IF LEFT(@pattern, 1) = '^'
  BEGIN
    DECLARE @startPattern NVARCHAR(4000) = SUBSTRING(@pattern, 2, LEN(@pattern) - 1)
    IF LEFT(@matchString, LEN(@startPattern)) = @startPattern
      SET @result = 1
    RETURN @result
  END

  -- Handle end anchor ($)
  IF RIGHT(@pattern, 1) = '$'
  BEGIN
    DECLARE @endPattern NVARCHAR(4000) = SUBSTRING(@pattern, 1, LEN(@pattern) - 1)
    IF RIGHT(@matchString, LEN(@endPattern)) = @endPattern
      SET @result = 1
    RETURN @result
  END

  -- Simple substring match (no anchors)
  IF CHARINDEX(@pattern, @matchString) > 0
    SET @result = 1

  RETURN @result
END
