<?php

namespace Drupal\sqlsrv\Driver\Database\sqlsrv;

use Drupal\Core\Database\Query\Delete as QueryDelete;

/**
 * Sqlsvr implementation of \Drupal\Core\Database\Query\Delete.
 */
class Delete extends QueryDelete {

  /**
   * {@inheritdoc}
   */
  public function __toString() {
    // Get the base query from parent.
    $query = parent::__toString();

    // Add ROWLOCK hint to prevent lock escalation during concurrent deletes.
    // Pattern: DELETE FROM {table} -> DELETE FROM {table} WITH (ROWLOCK)
    $query = preg_replace(
      '/^DELETE\s+FROM\s+(\{[^}]+\})/i',
      'DELETE FROM $1 WITH (ROWLOCK)',
      $query
    );

    return $query;
  }

}
