<?php

namespace Drupal\sri_ui\Commands;

use Drupal\sri_ui\Services\HashGeneration;
use Drush\Commands\DrushCommands;

/**
 * Class SriUiDrushCommands.
 *
 * Custom Drush command to perform SRI hash activities.
 *
 * @package Drupal\sri_ui
 */
class SriUiDrushCommands extends DrushCommands {

  /**
   * The hash generation service.
   *
   * @var \Drupal\sri_ui\Services\HashGeneration
   */
  protected $hashGeneration;

  /**
   * Constructs a new SriUiDrushCommands object.
   *
   * @param \Drupal\sri_ui\Services\HashGeneration $hashGeneration
   *   The hash generation service.
   */
  public function __construct(HashGeneration $hashGeneration) {
    parent::__construct();
    $this->hashGeneration = $hashGeneration;
  }

  /**
   * Update external assets hash values based on the rules.
   *
   * @command sri-ui:update-assets-hash256
   * @aliases update-assets-hash256
   */
  public function updateAssetsHash(): void {
    $this->hashGeneration->hashKeyGeneration('check_all');
  }

}
