<?php 

namespace Drupal\Tests\sri_ui\Unit;

use Drupal\sri_ui\Services\HashGeneration;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Cache\CacheTagsInvalidatorInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\Core\Config\Config;
use Prophecy\Argument;

/**
 * Class HashGenerationTest.
 *
 * @package Drupal\Tests\sri_ui\Unit
 * @coversDefaultClass \Drupal\sri_ui\Services\HashGeneration
 */
class HashGenerationTest extends UnitTestCase {

  /**
   * Your HashGeneration service.
   *
   * @var \Drupal\sri_ui\Services\HashGeneration
   */
  protected $hashGenerationService;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $configFactory = $this->prophesize(ConfigFactoryInterface::class);
    $config = $this->prophesize(Config::class);
    $config->get(Argument::any())->willReturn([]);
    
    // Return $config when getEditable method called.
    $configFactory->getEditable(Argument::type('string'))->willReturn($config->reveal());

    $loggerChannelFactory = $this->prophesize(LoggerChannelFactoryInterface::class);
    $cacheTagsInvalidator = $this->prophesize(CacheTagsInvalidatorInterface::class);

    $this->hashGenerationService = new HashGeneration(
        $configFactory->reveal(),
        $loggerChannelFactory->reveal(),
        $cacheTagsInvalidator->reveal()
    );
  }

  /**
   * Tests hash key generation.
   *
   * @covers ::hashKeyGeneration
   */
  public function testHashKeyGeneration() {
    $this->hashGenerationService->hashKeyGeneration();

    $this->assertTrue(TRUE, 'Test ran without exceptions.');
  }
}