<?php

namespace Drupal\sri_ui\EventSubscriber;

use Drupal\sri_ui\Services\HashGeneration;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Call the event subscriber on each page load.
 */
class SriEventSubscriberCron implements EventSubscriberInterface {


  /**
   * The configuration object factory.
   *
   * @var \Drupal\sri_ui\Services\HashGeneration
   */
  protected $hashGeneration;

  public function __construct(HashGeneration $hashGeneration) {
    $this->hashGeneration = $hashGeneration;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    // Specify the event to subscribe to and the method to call.
    $events[KernelEvents::REQUEST][] = ['onPageLoad', 0];
    return $events;
  }

  /**
   * Callback function to be called on page load.
   *
   * @param \Symfony\Component\HttpKernel\Event\RequestEvent $event
   *   To call the key update function.
   */
  public function onPageLoad(RequestEvent $event) {
    $this->hashGeneration->hashKeyGeneration('check_one_by_one');
  }

}
