<?php

namespace Drupal\ssid\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * @FieldWidget(
 *   id = "scope_serial_default_widget",
 *   label = @Translation("Default widget"),
 *   field_types = {
 *     "scope_serial"
 *   }
 * )
 */
class ScopeSerialDefaultWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $plugin = $items[$delta]->plugin ?? '';
    $scope = $items[$delta]->scope ?? '';
    $serial = $items[$delta]->serial ?? 0;
    $element['plugin'] = [
      '#type' => 'hidden',
      '#value' => $plugin,
    ];
    $element['scope'] = [
      '#type' => 'hidden',
      '#value' => $scope,
    ];
    $element['serial'] = [
      '#type' => 'hidden',
      '#value' => $serial,
    ];

    return $element;
  }

}
