<?php

namespace Drupal\ssid\Plugin;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines the base class for Scope plugins.
 */
abstract class Scope implements ScopeInterface {

  /**
   * {@inheritdoc}
   */
  public function getPluginId() {
    return $this->pluginId;
  }

  /**
   * {@inheritdoc}
   */
  public function getPluginDefinition() {
    return $this->pluginDefinition;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container,array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $container,
      $configuration,
      $plugin_id,
      $plugin_definition
    );
  }

}
