<?php

namespace Drupal\ssid\Plugin;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines the interface for Scope plugins.
 */
interface ScopeInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  /**
   * Gets the scope to set identifiers. This will tell the data
   * when it should reset the counter.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity that is going to be saved.
   * @param array $context
   *   Extra useful information, like the field name.
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string;

}
