<?php

namespace Drupal\ssid\Plugin\ssid\Scope;

use Drupal\ssid\Plugin\Scope;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides a daily scope for serial generation.
 *
 * @Scope(
 *   id = "daily",
 *   label = @Translation("Daily scope"),
 *   description = @Translation("Resets the serial each day.")
 * )
 */
class DailyScope extends Scope {

  /**
   * {@inheritdoc}
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string {
    return date('Y-m-d');
  }

}
