<?php

namespace Drupal\ssid\Plugin\ssid\Scope;

use Drupal\ssid\Plugin\Scope;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides an infinite scope for serial generation.
 *
 * @Scope(
 *   id = "infinite",
 *   label = @Translation("Infinite (No reset)"),
 *   description = @Translation("No reset. It will keep counting and counting (kinda another entity ID).")
 * )
 */
class InfiniteScope extends Scope {

  /**
   * {@inheritdoc}
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string {
    return '___';
  }

}
