<?php

namespace Drupal\ssid\Plugin\ssid\Scope;

use Drupal\ssid\Plugin\Scope;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides a monthly scope for serial generation.
 *
 * @Scope(
 *   id = "monthly",
 *   label = @Translation("Monthly scope"),
 *   description = @Translation("Resets the serial each month.")
 * )
 */
class MonthlyScope extends Scope {

  /**
   * {@inheritdoc}
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string {
    return date('Y-m');
  }

}
