<?php

namespace Drupal\ssid\Plugin\ssid\Scope;

use Drupal\ssid\Plugin\Scope;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides a weekly scope for serial generation.
 *
 * @Scope(
 *   id = "weekly",
 *   label = @Translation("Weekly scope"),
 *   description = @Translation("Resets the serial each week.")
 * )
 */
class WeeklyScope extends Scope {

  /**
   * {@inheritdoc}
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string {
    // ISO-8601 week: e.g., 2025-W40.
    return date('o-\WW');
  }

}
