<?php

namespace Drupal\ssid\Plugin\ssid\Scope;

use Drupal\ssid\Plugin\Scope;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides a yearly scope for serial generation.
 *
 * @Scope(
 *   id = "yearly",
 *   label = @Translation("Yearly scope"),
 *   description = @Translation("Resets the serial each year.")
 * )
 */
class YearlyScope extends Scope {

  /**
   * {@inheritdoc}
   */
  public function getScope(ContentEntityInterface $entity, array $context = []): string {
    return date('Y');
  }

}
